/**
 * 
 * Find more about the scrolling function at
 * http://cubiq.org/scrolling-div-on-iphone-ipod-touch/5
 *
 * Copyright (c) 2009 Matteo Spinelli
 * Released under the MIT license
 * http://cubiq.org/dropbox/mit-license.txt
 * 
 * Version 2.0 - Last updated: 2009.02.06
 * 
 */

function iScroll(el)
{
	this.element = el;
	this.position = 0;
	this.maxScroll = this.element.parentNode.clientHeight - this.element.offsetHeight;
	this.element.style.webkitTransitionDuration = '0';
	this.element.style.webkitTransitionTimingFunction = 'cubic-bezier(0, 0, 0.2, 1)';
	this.acceleration = 0.009;

	this.element.addEventListener('touchstart', this, false);
	this.element.addEventListener('touchmove', this, false);
	this.element.addEventListener('touchend', this, false);
}

iScroll.prototype = {
	handleEvent: function(e) {
		switch(e.type) {
			case 'touchstart': this.onTouchStart(e); break;
			case 'touchmove': this.onTouchMove(e); break;
			case 'touchend': this.onTouchEnd(e); break;
			case 'webkitTransitionEnd': this.onTransitionEnd(e); break;
		}
	},

	get position() {
		return this._position;
	},
	
	set position(pos) {
		this._position = pos;

		if( this._position>this.element.parentNode.clientHeight-10 )
			this._position = this.element.parentNode.clientHeight-10;
		else if( this._position<this.maxScroll-this.element.parentNode.clientHeight-10 )
			this._position = this.maxScroll-this.element.parentNode.clientHeight-10;
		
		this.element.style.webkitTransform = 'translate(0, ' + this._position + 'px)';
	},
	
	onTouchStart: function(e) {
		e.preventDefault();

		if( e.targetTouches.length != 1 )
			return false;

		var theTransform = parseInt(window.getComputedStyle(this.element,null).webkitTransform.split(',')[13]);
		if( theTransform!=this.position )
			this.position = theTransform;
		
		this.element.style.webkitTransitionDuration = '0';	// Remove any transition
		this.startY = e.targetTouches[0].clientY;
		this.scrollStartY = this.position;
		this.scrollStartTime = e.timeStamp;
		
		return false;
	},
	
	onTouchMove: function(e) {
		e.preventDefault();

		if( e.targetTouches.length != 1 )
			return false;
		
		var topDelta = e.targetTouches[0].clientY - this.startY;
		if( this.position>0 || this.position<this.maxScroll ) topDelta/=2;
		this.position = this.position + topDelta;
		this.startY = e.targetTouches[0].clientY;

		// Prevent slingshot effect
		if( e.timeStamp-this.scrollStartTime>100 ) {
			this.scrollStartY = this.position;
			this.scrollStartTime = e.timeStamp;
		}

		return false;
	},
	
	onTouchEnd: function(e) {
		e.preventDefault();

		if( e.targetTouches.length > 0 )
			return false;

		// If we are outside of the boundaries, let's go back to the sheepfold
		if( this.position>0 || this.position<this.maxScroll ) {
			this.autoScroll(this.position>0 ? 0 : this.maxScroll);
			return false;
		}

		var scrollDistance = this.position - this.scrollStartY;

		// The drag session was too short or inexistent so we simulate a mouse click
		if( scrollDistance<5 && scrollDistance>-5 ) {
			var theTarget = e.target;
			if(theTarget.nodeType == 3) theTarget = theTarget.parentNode;
			var theEvent = document.createEvent("MouseEvents");
			theEvent.initMouseEvent("click", true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
			theTarget.dispatchEvent(theEvent);
			return false
		}

		// Very lame formula to calculate a fake deceleration
		var scrollDuration = e.timeStamp - this.scrollStartTime;

		var newDuration = (2 * scrollDistance / scrollDuration) / this.acceleration;
		var newScrollDistance = (this.acceleration / 2) * (newDuration * newDuration);
		
		if( newDuration<0 ) {
			newDuration*=-1;
			newScrollDistance*=-1;
		}

		var newPosition = this.position + newScrollDistance;
		
		// Slow down if outside of boundaries
		if( newPosition>0 )
			newPosition/= 2;
		else if( newPosition<this.maxScroll )
			newPosition = (newPosition - this.maxScroll) / 2 + this.maxScroll;
		else
			newDuration*= 6;

		this.autoScroll(newPosition, Math.round(newDuration) + 'ms');

		// At the end of the transition check if we are out of boundaries
		this.element.addEventListener('webkitTransitionEnd', this, false);
		
		return false;
	},
	
	onTransitionEnd: function() {
		if( this.position>0 || this.position<this.maxScroll )
			this.autoScroll( this.position>0 ? 0 : this.maxScroll );

		this.element.removeEventListener('webkitTransitionEnd', this, false);
	},
	
	autoScroll: function(dest, runtime) {
		this.element.style.webkitTransitionDuration = runtime ? runtime : '300ms';
		this.position = dest ? dest : 0;
	}
};